# Security Policy

If you have run a CVE/security scanner on an image and that is why you are here, you should read [our "Why does my security scanner show that an image has CVEs?" FAQ entry](https://github.com/docker-library/faq#why-does-my-security-scanner-show-that-an-image-has-cves).

If you believe you have found a net new security vulnerability, please make every effort to report it to the appropriate maintainers responsibly so that it can be fixed discreetly (also known as "embargo").

When the issue relates to a specific image, please make an effort to (privately) contact the maintainers of that specific image.  Some maintainers publish/maintain a `SECRUITY.md` in their GitHub repository, for example, which can be a great place to find information about how to report an issue appropriately.

For issues related to anything maintained under [@docker-library on GitHub](https://github.com/docker-library) or associated infrastructure, please [send an email to `doi@docker.com`](mailto:doi@docker.com) or [use GitHub's security advisory feature](https://github.com/docker-library/official-images/security/advisories/new).

Image maintainers should also be aware of the ["Security Releases" section of the maintainer documentation](https://github.com/docker-library/official-images#security-releases) for pre-notifying the project maintainers of upcoming security-related releases.
